from tracegnn.utils import best_fscore
from tracegnn.visualize import *
import pandas as pd


def load_data(path):
    data = pd.read_csv(path)
    nll_list = data['score'].values
    label_list = data['label'].values
    return nll_list, label_list


if __name__ == '__main__':
    init_plot_styles()

    algorithms = {}
    for name, algo in [('rnvp', 'rnvp')]:
        nll_list, label_list = load_data(f'tracegnn/models/trace_anomaly/result/{algo}_test.csv')
        plot_proba_cdf(nll_list, label_list, title=algo)
        plt.savefig(f'tracegnn/models/trace_anomaly/result/{algo}.png')
        plt.close()

        label_list = label_list != 0
        algorithms[algo] = (nll_list, label_list)
        print(algo, best_fscore(nll_list, label_list))

    fig = plot_anomaly_auc_curve(algorithms)
    plt.show()
    plt.close()
