Contributing
===

To install ZhuSuan in an "editable" or "develop" mode, run
```
pip install -e .
```
in the main directory. This installation is removable by
```
python setup.py develop --uninstall
```
Additional dependencies for developments can be installed by
```
pip install ".[dev]"
```

#### Tests

This command will run automatic tests in the main directory
```
python -m unittest discover -v
```

##### Test Coverage
After running tests, to ensure test coverage over the developments, run
```
coverage report --include="zhusuan/*"
```

##### PEP8 Code Style Check

We follow PEP8 python code style. To check, in the main directory, run::
```
pep8 .
```

#### Docs

Docs are written under the `docs/` directory as RestructuredText (`.rst`)
files. `index.rst` is the main page. A Tutorial on RestructuredText can be
found [here](https://pythonhosted.org/an_example_pypi_project/sphinx.html).

API References are automatically generated by
[Sphinx](http://www.sphinx-doc.org/en/stable/) according to the outlines under 
`doc/api/` and should be modified when any code changes.

To compile docs into webpages, Run
```
make html
```
under the `docs/` directory. The generated webpages are in `docs/_build` and
can be viewed with browsers.
