import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * Created by ZDH on 2017/7/21.
 */
public class TestServiceTrain {
    private WebDriver driver;
    private String baseUrl;
    @BeforeClass
    public void setUp() throws Exception {
        System.setProperty("webdriver.chrome.driver", "D:/Program/chromedriver_win32/chromedriver.exe");
        driver = new ChromeDriver();
        baseUrl = "http://10.141.212.24/";
        driver.manage().timeouts().implicitlyWait(30, TimeUnit.SECONDS);
    }
    @Test
    public void testTrain() throws Exception{
        driver.get(baseUrl + "/");
        JavascriptExecutor js = (JavascriptExecutor) driver;
        js.executeScript("document.getElementById('train_update_id').value='GaoTieOne'");
        js.executeScript("document.getElementById('train_update_economyClass').value='120'");
        js.executeScript("document.getElementById('train_update_confortClass').value='60'");

        driver.findElement(By.id("train_update_button")).click();
        Thread.sleep(1000);
//        String statusSignIn = driver.findElement(By.id("login_result_msg")).getText();
//        if(statusSignIn ==null || statusSignIn.length() <= 0) {
//            System.out.println("Failed,Status of Sign In btn is NULL!");
//            driver.quit();
//        }else
//            System.out.println("Sign Up btn status:"+statusSignIn);
    }
    @Test (dependsOnMethods = {"testTrain"})
    public void testQueryTrain() throws Exception{
        driver.findElement(By.id("train_query_button")).click();
        Thread.sleep(1000);
        //gain Travel list
        List<WebElement> trainList = driver.findElements(By.xpath("//table[@id='query_train_list_table']/tbody/tr"));

        if (trainList.size() > 0)
            System.out.printf("Success to Query Train and Train list size is %d.%n",trainList.size());
        else
            System.out.println("Failed to Query Train or Train list size is 0");
        Assert.assertEquals(trainList.size() > 0,true);
    }
    @AfterClass
    public void tearDown() throws Exception {
        driver.quit();
    }
}
