# 提交脚本使用指南

本指南介绍如何在竞赛中向评测服务器提交答案。该脚本允许您提交一个答案文件，并在操作成功时获得提交 ID。

## 环境要求

在开始之前，请确保您的系统已安装 Python 3。

## 脚本概览

脚本接受一个 JSON Lines 文件（`*.jsonl`），每行是一个单独的 JSON 对象，代表一个问题回答。

## 命令行提交

要从命令行使用该脚本，请切换到该脚本所在目录，用 Python 运行该脚本：

```bash
python submit.py [-h] [-s SERVER] [-k TICKET] [result_path]
```

* `[result_path]`: 提交的结果文件路径。如果未指定，默认使用当前目录下的 `result.jsonl`。
* `-s, --server`：指定评测服务器的 URL。如果未提供，将使用脚本中定义的 `JUDGE_SERVER` 变量。
* `-k, --ticket`：团队标识。如果未提供，将使用脚本中定义的 `TICKET` 变量。

## 编程方式提交

您还可以将 `submit` 函数导入到您的 Python 代码中，以便用编程方式提交数据。


1. 导入函数：
    确保提交脚本位于您的项目目录或 Python 路径中。使用以下方式导入 submit 函数：

    ```python3
    from submit import submit
    ```

2. 调用 submit 函数：
    准备您的提交数据为字典列表，每个字典代表一个要提交的问题回答。调用 submit 函数：

    ```python3
    data = [
        {"id": 1, "query": "问题 1", "answer": "答案 1"},
        {"id": 2, "query": "问题 2", "answer": "答案 2"},
        {"id": 3, "query": "问题 3", "answer": "答案 3"},
        # 根据需要添加更多项
    ]

    submission_id = submit(data, judge_server='http://judge.aiops-challenge.com', ticket='YOUR_TEAM_TICKET')
    if submission_id:
        print("提交成功！提交 ID: ", submission_id)
    else:
        print("提交失败")
    ```
    
    http://judge.aiops-challenge.com 为评测服务器地址

    YOUR_TEAM_TICKET 为团队的ID 
